/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.client.model.HeadphoneModel;
import com.stevekung.fishofthieves.entity.AbstractThievesFish;
import com.stevekung.fishofthieves.entity.animal.Wrecker;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;

public class WreckerModel<T extends Wrecker>
extends EntityModel<T>
implements HeadphoneModel.Scaleable<T> {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(FishOfThieves.id("wrecker"), "main");
    private final ModelPart head;
    private final ModelPart body_main;
    private final ModelPart body_back;
    private final ModelPart bulb;
    private final ModelPart mouth;

    public WreckerModel(ModelPart part) {
        super(RenderType::entityCutout);
        this.head = part.getChild("head");
        this.body_main = part.getChild("body_main");
        this.body_back = part.getChild("body_back");
        this.bulb = this.head.getChild("bulb");
        this.mouth = this.head.getChild("mouth");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition head = partDefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)19.5f, (float)-3.55f, (float)0.1745f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -2.21f, -2.27f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.02f)), PartPose.offsetAndRotation((float)0.0f, (float)0.46f, (float)0.445f, (float)0.3054f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("bulb", CubeListBuilder.create().texOffs(18, 1).addBox(0.0f, -4.0f, -2.5f, 0.0f, 5.0f, 3.0f, CubeDeformation.NONE).texOffs(27, 19).addBox(-0.5f, -2.95f, -3.6f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.3f, (float)0.7f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)3.5f, (float)0.3f));
        mouth.addOrReplaceChild("mouth_r1", CubeListBuilder.create().texOffs(0, 25).addBox(0.1f, -2.0f, 0.0f, 0.0f, 2.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-2.7f, (float)-4.5f, (float)-2.75f, (float)-1.0472f, (float)-0.1134f, (float)-0.0654f));
        mouth.addOrReplaceChild("mouth_r2", CubeListBuilder.create().texOffs(0, 25).addBox(-0.1f, -2.0f, 0.0f, 0.0f, 2.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.7f, (float)-4.5f, (float)-2.75f, (float)-1.0472f, (float)0.1134f, (float)0.0654f));
        mouth.addOrReplaceChild("mouth_r3", CubeListBuilder.create().texOffs(10, 30).addBox(-2.5f, -1.5f, 0.0f, 5.0f, 2.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-4.65f, (float)-2.75f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        mouth.addOrReplaceChild("mouth_r4", CubeListBuilder.create().texOffs(0, 24).addBox(-2.5f, 0.2f, -4.85f, 5.0f, 1.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.35f, (float)-0.25f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition body_main = partDefinition.addOrReplaceChild("body_main", CubeListBuilder.create().texOffs(0, 9).addBox(-2.5f, -6.9f, -2.5f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.01f)).texOffs(20, 21).addBox(0.0f, -9.9f, -1.5f, 0.0f, 3.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        body_main.addOrReplaceChild("right_fin_r1", CubeListBuilder.create().texOffs(27, 21).addBox(-2.0f, -4.9f, 0.0f, 2.0f, 2.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.8727f, (float)0.0f));
        body_main.addOrReplaceChild("left_fin_r1", CubeListBuilder.create().texOffs(27, 23).addBox(0.0f, -4.9f, 0.0f, 2.0f, 2.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.8727f, (float)0.0f));
        body_main.addOrReplaceChild("body_main_r1", CubeListBuilder.create().texOffs(0, 18).addBox(-2.5f, -0.9f, -5.0f, 5.0f, 1.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)1.5f, (float)0.2094f, (float)0.0f, (float)0.0f));
        PartDefinition body_back = partDefinition.addOrReplaceChild("body_back", CubeListBuilder.create().texOffs(18, 10).addBox(-1.5f, -2.0f, -1.0f, 3.0f, 4.0f, 4.0f, CubeDeformation.NONE).texOffs(20, 25).addBox(0.0f, -5.0f, 0.0f, 0.0f, 3.0f, 3.0f, CubeDeformation.NONE).texOffs(20, 15).addBox(0.0f, -2.5f, 3.0f, 0.0f, 5.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)19.5f, (float)1.5f));
        body_back.addOrReplaceChild("right_fin_r2", CubeListBuilder.create().texOffs(26, 23).addBox(-0.5f, -0.5f, 1.5f, 0.0f, 2.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-1.25f, (float)2.5f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.5236f));
        body_back.addOrReplaceChild("left_fin_r2", CubeListBuilder.create().texOffs(26, 25).addBox(0.5f, -0.5f, 1.5f, 0.0f, 2.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.25f, (float)2.5f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float backRotation = 1.0f;
        float backRotSpeed = 1.0f;
        float mouthSpeed = 0.4f;
        float bulbSpeed = 0.1f;
        if (!entity.isInWater() && !((AbstractThievesFish)entity).isNoFlip()) {
            backRotation = 1.5f;
            backRotSpeed = 1.7f;
            mouthSpeed = 1.8f;
        }
        this.body_back.yRot = -backRotation * 0.2f * Mth.sin((float)(backRotSpeed * 0.6f * ageInTicks));
        this.mouth.xRot = 0.1f + Mth.cos((float)(mouthSpeed * ageInTicks)) * (float)Math.PI * 0.07f;
        this.bulb.xRot = 0.25f + Mth.cos((float)(bulbSpeed * ageInTicks)) * (float)Math.PI * 0.03f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int packedColor) {
        this.head.render(poseStack, buffer, packedLight, packedOverlay, packedColor);
        this.body_main.render(poseStack, buffer, packedLight, packedOverlay, packedColor);
        this.body_back.render(poseStack, buffer, packedLight, packedOverlay, packedColor);
    }

    @Override
    public void scale(T entity, PoseStack poseStack) {
        float scale = 2.0f;
        poseStack.scale(scale, scale - 0.5f, scale - 0.5f);
        poseStack.translate(0.0f, -0.3f, -0.04f);
    }
}

